  org 100h  ; assume ax=bx=0 si=100h sp=-2

  db 0x3F            ; aas
  db 0xC1,122,90h,40 ; sar word [bp+si-0x70],40
  db 91h             ; xchg ax,cx
  db 7               ; pop es

  push cx     ; 0
  mov di,si   ; initial song position = 256

  mov dx,331h
  outsb       ; 0x3F: UART simple mode
  dec dx
  outsb       ; 0xC1: Program change, channel 2
  outsb       ; 122: Seashore

; Play notes for the current tick.
M:mov cl,31   ; max polyphony = 32
  xor ebp,ebp ; the cycle has 32 ticks: which ticks have played a note?
  xor bx,bx   ; note time
  mov al,18   ; number of ticks between notes = 18

Z pusha

  lea ax,[bx+di] ; song time minus note time
  and ax,801Fh   ; should it play yet? and on this tick?
  mov al,' '
  jnz N

  imul ax,cx,-12 ; 12 notes in octave
  add ax,32*7+12*31+5 ; first note is D
  div byte[si+3]  ; 7 notes in scale

  outsb       ; 0x90: Note On, channel 1

  cmp al,36   ; new seashore sound on lowest two notes
  out dx,al   ; note
  outsb       ; velocity 36
  ja Q

  outsb       ; Note On, channel 2
  out dx,al   ; note 35 or 36
  out dx,al   ; velocity 35 or 36

Q:
  mov al,'*'
N:
  int 29h

  popa

  bts ebp,ebx
  jnc K
  xor al,29^18; if there's a note on this tick, switch 18<->29
K sub bx,ax   ; note time += 18 or 29

  loop Z

  mov al,0xD  ; carriage return
  int 29h

  mov al,[es:0x46c]  ; bx=-29C si=103
  add al,4    ; wait 219.7 ms
W:cmp al,[es:0x46c]
  jne W

  inc di

  in al,60h
  cmp al,1
  jnz M
  ret
